/**
 * Implmente une file d'objets (simule la gnricit sauf que l'utilisation
 * demande de transtyper les objets reus)
 * 
 *  
 * @version automne 2012
 */
public class File {
    
	  /*
	  *STRATEGIE : Implmentation statique
	  *
	  *            Nous prendrons un tableau avec deux indices qui servent
	  *             retenir o se trouve l'lment de dbut et o se trouve
	  *            l'lment de fin.  Le modulo est utilis pour simuler
	  *            un tableau circulaire.
	  *            
	  *            La file est vide s'il y a 0 lments
	  *            La file est pleine si le nombre d'lments est gal  la taille 
	  *            du tableau
	  *            
	  *            Le constructeur par dfaut dfinit une taille de MIN_ELEMENT
	  */
	 /**********************
	 *attributs
	 ***********************/
	//taille par dfaut de la file
	 public static int MIN_ELEMENT = 100;
	 
	 //debut et fin de la file
	 int debut = 0;
	 int fin = 0;
		 
	 //Toujours maintenu  jour
	 int nbElements;
	 
	 //la file est un tableau d'objets
	 Object[] file;
	 
    /**
     * Constructeur par dfaut
     * 
     * Il y aura File.MIN_ELEMENT possible dans la file
     */
    public File(){
    	file = new Object[MIN_ELEMENT];
    }
    
    /**
     * Construit une file de la taille demande
     * @param taille La taille voulue pour la file 
     */
    public File(int taille){
    	file = new Object[taille];
    }
    
    
    /**
     * Met la valeur  la fin de la file
     * @param element l'lment  enfiler
     * @throws FilePleineException  Tente d'enfiler dans une file pleine
     */
    public void ajoute (Object element) throws FilePleineException{
    	
    	//Si la file est pleine, on avise  l'aide d'une exception
    	if(nbElements == file.length)
    		throw new FilePleineException("La file est pleine; il y a dj " + 
    				                       nbElements + " elements");

    	//On enfile  la fin
    	file[fin] = element;
    	
    	//On dplace l'indice.  Le modulo sert 
    	// obtenir un 
    	//tableau circulaire (Si ++fin == MIN_ELEMENT alors fin = 0)
    	fin = ++fin % file.length;
    	
    	
    	//Un lment de plus
    	nbElements++;
    }

    /**
     * Retourne la valeur du dessus de la file
     * antecedent : la file ne doit pas tre vide
     * consequent : l'lment de tte n'est plus dans la file
     * @return le premier de la file
     * @throws FileVideException  
     */
    public Object obtient () throws FileVideException{
    	Object element = null;
    	    	
    	//Si la file est vide, on avise  l'aide d'une exception
		if(nbElements == 0)
			throw new FileVideException("La file est vide; impossible de dfiler");
		
		
		//On rcupre le premier lment 
		element = file[debut];
		
		//dplace la tte sur la case suivante
		//de faon circulaire(Si ++debut == MIN_ELEMENT alors debut = 0)
		debut = ++debut % file.length;
		
		//Un lment de moins
		nbElements--;
		
        return element;
    }
    
    /**
     * @return vrai si la  file est vide et faux sinon
     */
    public boolean estVide(){
        return nbElements == 0;
    }
    
    /**
     * Permet de rcuprer la valeur du dessus 
     * de la file sans l'enlever de la file
     * antecedent : la file n'est pas vide
     * @return le premier de la file
     * @throws FileVideException      
     */
    public Object defileSansEnlever() throws FileVideException{
    	
    	
    	//Si la file est vide, on avise  l'aide d'une exception
    	if(nbElements == 0)
		    throw new FileVideException("La file est vide; impossible de dfiler");
    	
    	return file[debut];
    }
    
    
    /**
     * Vide la file
     * consquent : estVide() == true
     * @throws FileVideException  
     */    
    public void vider(){
    	
    	//On place la tte et la fin sur la mme case
        debut = fin = 0;
    	nbElements = 0;
    }    
}